
import numpy as np
import sys

class Channel:
	"""
	Description:
		Channel model to add ISI with given SBR.
		It also add gaussian noise with given sigma.
		Note that given SBR is normlalized in the function.
		Normalize to keep the signal power 1 (constant)
		This will make SNR calculation simple 
	"""
	#TODO SNR caculation is wrong for pam4 and pam8
	def __init__(self, sbr, snr=20):
		"""
		Params:
			sbr(float list)	: SBR to be added
			snr(float)		: Noise magnitude. sigma = 10^(-snr/20)
		"""
		self.sbr_ = np.array(sbr)
		self.sbr_ /= np.linalg.norm(self.sbr_)
		# std for AWGN
		self.sigma_ = 10**(float(-snr) / 20)
		#print self.sigma_
	def run(self, chIn, flagN=1):
		"""
		Description:
			Generate ISI and noise added data
		Params:
			chIn(float list) 	: Channel input data. Usually generated from Tx(Class)
		Return:
			out(float list)		: equals to 'conv(in,sbr) + noise'
		"""
		out = np.convolve(chIn, self.sbr_)
		if flagN:
			noise = np.random.normal(0,self.sigma_,len(out))
			out += noise
			#print(self.sigma_)
			#print(np.std(noise))
			#print(np.sum(noise>np.max(self.sbr_)))
			#print(np.max(self.sbr_))
			#sys.exit()
		return out


